/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.ui;

import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public record GuiSlot(@Nullable GuiElementInterface element, @Nullable class_1735 slot) {
    private static final GuiSlot EMPTY = GuiSlot.of((GuiElementInterface)new GuiElement(class_1799.field_8037, GuiElementInterface.EMPTY_CALLBACK));

    public static GuiSlot of(GuiElementInterface element) {
        return new GuiSlot(element, null);
    }

    public static GuiSlot of(GuiElementBuilderInterface<?> element) {
        return new GuiSlot(element.build(), null);
    }

    public static GuiSlot of(class_1735 slot) {
        return new GuiSlot(null, slot);
    }

    public static GuiSlot nextPage(PagedGui gui) {
        Config config = ConfigManager.getConfig();
        if (gui.canNextPage()) {
            return GuiSlot.of(config.ui.nextButton.get(true).builder().noDefaults().hideDefaultTooltip().setCallback((x, y, z) -> {
                PagedGui.playClickSound(gui.getPlayer());
                gui.nextPage();
            }));
        }
        return GuiSlot.of(config.ui.nextButton.get(false).builder().noDefaults().hideDefaultTooltip());
    }

    public static GuiSlot previousPage(PagedGui gui) {
        Config config = ConfigManager.getConfig();
        if (gui.canPreviousPage()) {
            return GuiSlot.of(config.ui.previousButton.get(true).builder().noDefaults().hideDefaultTooltip().setCallback((x, y, z) -> {
                PagedGui.playClickSound(gui.getPlayer());
                gui.previousPage();
            }));
        }
        return GuiSlot.of(config.ui.previousButton.get(false).builder().noDefaults().hideDefaultTooltip());
    }

    public static GuiSlot filler() {
        return GuiSlot.of(ConfigManager.getConfig().ui.barButton.builder().hideTooltip());
    }

    public static GuiSlot empty() {
        return EMPTY;
    }

    public static GuiSlot lowerBar(class_3222 player) {
        return GraveTextures.hasGuiTexture(player) ? GuiSlot.empty() : GuiSlot.filler();
    }

    public static GuiSlot back(Runnable back) {
        Config config = ConfigManager.getConfig();
        return GuiSlot.of(config.ui.backButton.builder().noDefaults().hideDefaultTooltip().setCallback((x, y, z, d) -> {
            PagedGui.playClickSound(d.getPlayer());
            back.run();
        }));
    }
}

